function Autogram(x,level,Fs,lmp,Dr,Dn,Spe,UL,Res,UP,CUR)



% This subroutine computes the Autogram of signal x up to level 'level' by 
% using an undecimated Wavelet Packet Transform (modwpt).
% Fs = sampling frequency

% ----------------------------------------------------

% Reference: The Autogram: an effective approach for selecting the optimal
% demodulation band in rolling element bearings diagnosis 
% Authors: Moshrefzadeh A, Fasana A
% Journal: Mechanical Systems and Signal Processing

%% Maximal Overlap Discrete Wavelet Packet Transform (modwpt)
% ==============================================================
global fr
%tic
x = x - mean(x);

[wp,~,~] = modwpt(x(1:end),'db12','Fulltree',true,level);

for lev = 1 : level    
    jj = 0;
    for v = 0:lev-1
        jj = jj + 2^v;
    end
    jj = jj-1;   
    wpt(1:2^lev,1:length(x),lev) = wp(jj+1:jj+2^lev, 1:length(x));    
end

%% Plot the raw signal
% =======================
t = 0:1/Fs:length(x)/Fs-1/Fs;
figure('units','normalized','outerposition',[0.3 0.5 0.7 0.5])
plot(t,x)
%set(gca,'Fontsize',15);set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman')
xlabel('Time (s)'),xlim([0 max(t)])
ylabel('Acceleration (m/s^2)')
title('Raw time signal')
%% Compute Autogram   
% ====================
ss0 = floor(0.005*length(x));  % Removing the filter transient
if CUR == 0
    cor = 0.010;
elseif CUR == 1
    cor = 0.15;
end   
ss = floor(cor*length(x))+1;   % Removing a few first samples of AC
AAA = 1.55;

y = hilbert(x);
env = abs(y);
[acor,~] = xcorr((env).^2,'unbiased'); 
KUR(1,1) = Kurt((acor(length(x)+ss:floor(length(x)*AAA))),lmp);

for lev = 1:level    
    for i = 1:2^(lev)
        y = hilbert(wpt(i,ss0:length(x)-ss0,lev));
        env = abs(y);
        [acor,~] = xcorr((env).^2,'unbiased');  
        KUR(lev+1,i) = Kurt((acor(length(x)+ss:floor(length(x)*AAA)))',lmp);
    end     
end

T = 2^level;
for lev = 0:level
    TE = T/2^lev; 
    for i = 1:2^lev    
        color((i-1)*TE+1:(i)*TE,lev+1) = KUR(lev+1,i);         
    end       
end

[M,~] = max(KUR(:));
disp('----')
disp(['Autogram -- Max Kurtosis = ',num2str(M)])
[i, j] = find(KUR==M);
LM1 = i-1;
JM1 = j;
disp(['level = ',num2str(LM1)])
disp(['node = ',num2str(JM1)])

%% Plot Autogram
% ================
% figure('units','normalized','outerposition',[0.0 0.5 0.3 0.5])
figure;
imagesc(0:0.5*Fs/2^level:0.5*Fs,0:1:level,color')
%set(gca,'Fontsize',16);%set(gca,'FontWeight','Bold')
%set(gca,'Fontname','Times new roman')
xlabel('Frequency (Hz)');ylabel('Level')
colorbar
title(['Autogram - K_{max}= ',sprintf('%0.1f',M),' @ level ',num2str(LM1),', Bw= ',num2str(Fs/2^(LM1+1)),'Hz, f_c= ',num2str(j/2^LM1*Fs*0.5-Fs/2^(LM1+2)),'Hz'])
%toc                                     

%% Compute defect frequencies for the CWRU bearings
% ========================================================
% fd = 0; fs = 0; fr = 0; asdf = 0;
% 
% if Spe ~= 0
% speedr = [1797 1772 1750 1730]; 
% ratio = [5.415 3.585 0.3983 2.357; 4.947 3.053 0.3816 1.994] ;
% fr = speedr(Spe)/60;
% if Drive_end == 1
%     j = 1;
% else
%     j = 2;
% end
% fd = fr * ratio(j, Dn);
% if Dn == 1
%     asdf = 1;
%     fs = fr;
% elseif Dn == 4
%     asdf = 1;
%     fs = ratio(j,3)*fr;
% else
%     asdf = 0;
%     fs = 0;
% end
% end
fd=0;
fs=0;
% fr=0;
asdf=0;
%% Squared Envelope Spectrum (SES)
% ==================================
NN = 4000; % length of the SES

% Manually set the node and level for demodulation
% JM1 = 15; % node
% LM1 = 5;  % level

if LM1 == 0
    c0 = x;
else
    c0 = squeeze(wpt(JM1,:,LM1)');
end

c = c0(ss0:end-ss0);
y = hilbert(c);
c = abs(y);

[acor,~] = xcorr(((c).^2),'unbiased');
XA111 = (acor(length(c)+ss:floor(length(c)*AAA-1)));
Han = hanning(length(c));
nfft = 2*ceil(length(c)/2);
c = c';
%FT = abs(fft(((c).^2).*Han'./length(c),nfft));

env = abs(c).^2;
   FT = abs(fft((env(:)-mean(env)).*hanning(length(env))/length(env),nfft));
FT11 = FT;
Le = length(FT)-1;
XA111 = XA111 - min(XA111);
MEAN = movmean(XA111,10000);

% Plot SES
% ===========

%if UL == 1
    %figure('units','normalized','outerposition',[0.3 0 0.4 1])
    %subplot(3,1,1)
    figure;
   PLA(fd,fs,fr,Fs,Le,NN,FT11,asdf,1,Dn,c,nfft,level,LM1);
    title('Normalized SES - Autogram','FontSize', 12)
    xlabel('Frequency (Hz)')
    set(gca, 'XLabel', [])
    
% else
% figure
%     PLA(fd,fs,fr,Fs,Le,NN,FT11,asdf,1,Dn)
%     title('Normalized Amplitude spectrum of the squared envelope','FontSize', 12)
%     xlabel('Frequency (Hz)')
% end

% 
% % Plot the spectra after Upper and Lower threshold 
% % ==================================================
% 
% if UL == 1
%         poi = XA111 - UP*MEAN;
%         poiU = poi.*(poi>0);
%         poi = XA111 - 1*MEAN;
%         poiL = poi.*(poi<0);
%         
%     poiU = poiU';
%     poiL = poiL';
%     Han = hanning(length(XA111));
%     FTpoiL = abs(fft(poiL(1:length(XA111)).*Han',nfft));
%     FTpoiU = abs(fft(poiU(1:length(XA111)).*Han',nfft));
%     
%     subplot(3,1,2)
%     PLA(fd,fs,fr,Fs,Le,NN,FTpoiL,asdf,0,Dn)
%     title('SES (after lower threshold)','FontSize', 12)
%     set(gca, 'XLabel', [])
%     subplot(3,1,3)
%     PLA(fd,fs,fr,Fs,Le,NN,FTpoiU,asdf,0,Dn)
%     title('SES (after upper threshold)','FontSize', 12)
% end
% 
% %% Compute CSES and Average CSES
% % ===================================
% clear Z X Y aaf 
% 
% N0 = 10;
% for L = 1: level+1
%     if L == 1
%         n2 = 1;
%         c0 = x;
%         c = c0(ss0:end-ss0);
%         y = hilbert(c);
%         c = abs(y);
%         Han = hanning(length(c));
%         nfft = 2*ceil(length(c)/2);
%         c=c';
%         FT = abs(fft(((c).^2).*Han',nfft));
%         S = FT/max(FT(N0:NN+1)) ;      
%     else
%         MAX = max(KUR(L,:));
%         aaf(L-1,:) = (KUR(L,:) >= ( MAX * 0.5) );
%         [~, n2] = find(aaf(L-1,:) == 1);        
% S = 0;
% for i = 1 : length(n2)
%     
%     JM11 = n2(i);
%     LM11 = L-1;
%     c0 = squeeze(wpt(JM11,:,LM11)');
%     c = c0(ss0:end-ss0);
%     y = hilbert(c);
%     c = abs(y);
%     Han = hanning(length(c));
%     nfft = 2*ceil(length(c)/2);
%     c = c';
%     FT = abs(fft(((c).^2).*Han',nfft));
%                   
%     S = S + FT/max(FT(N0:NN+1)) ; 
% end
%     end
% X = (N0-1)*Fs/length(FT):1*Fs/length(FT):(NN-1)*Fs/length(FT);
% Y = 0:level;
% Z(L,:) = S(1:NN)/length(n2); 
% end
% %% Screen Resolution
% % =====================
% sxm = N0:sd:floor(NN)-N0+1;
% ZZm = transpose(Z(:,1:sd:floor(NN)-N0+1));
% for j = 1:L
% for i = 1:length(sxm)
%     ZZm(i,j) = max( Z(j, N0+(i-1)*sd:N0-1+sd*i) );
% end
end
% 
% %% plot CSES and Average CSES
% % ==============================
% figure('units','normalized','outerposition',[0 0 1 1])
% subplot(2,1,1)
% imagesc(X,Y,ZZm') % plot CSES
% set(gca,'Fontsize',16);set(gca,'FontWeight','Bold')
% set(gca,'Fontname','Times new roman')
% colormap Hot;ylabel('Level','FontSize', 18);colorbar('east')
% colormap(flipud(hot));caxis([0.1 0.8]);title CSES
% zxc = 0;
% for i = 0:level
%     zxc = zxc + Z(i+1,N0:end);
% end
% subplot(2,1,2)
% plot(X,zxc) % plot Average CSES
% xlim([0 max(X)])
% set(gca,'Fontsize',16);set(gca,'FontWeight','Bold')
% set(gca,'Fontname','Times new roman')
% xlabel('Frequency (Hz)','FontSize', 16);ylabel('Amplitude','FontSize', 18)
% title('Average CSES')
% end

%%% Subroutine for computing kurtosis
% ========================================
function K = Kurt(x,q)
if q == 0
    x = x - min(x);
elseif q == 1
    x = x - movmean(x,4000);
    x = x.*(x>0);      
elseif q == -1
    x = x - movmean(x,4000);
    x = x.*(x<0);  
end
x = x - min(x);
E = mean(abs(x).^2);
K = mean(abs(x).^4)/E^2;
end

%%
%%Subroutine for plotting the defect indicators 
% ========================================
function  PLA(fd,fs,fr,Fs,Le,NN,FT,asdf,ch,Dn,c,nfft,level,LM1)

dd = 0.0;
dmm= max(FT(11:floor(NN)+1).^1);
ddd = 1.2;% * dmm;
lw = 1.5;

hold on

% if Dn ~= 0 
%     xx = 1; % Number of shaft frequency harmonics
% for i = 1:xx
%     plot([i*fr i*fr], [dd ddd],'-.','color',[0 0.5 0]);
% end
% 
% xx = 2; % Number of defect frequency harmonics
% for i = 1:xx
%     plot([i*fd i*fd], [dd ddd],'--r');
% end
% end
% 
% if asdf == 1
%     hh = 1; % Number of sidebands for each harmonic
%     for i = 1:xx
%         for j = 1:hh
%         fside1 = i*fd + j*fs;
%         fside2 = i*fd - j*fs;
%         plot([fside1 fside1], [dd ddd],':r');
%         plot([fside2 fside2], [dd ddd],':r');
%         end
%     end
% end

if ch == 0
  % S = FT(11:NN+1).^1;
  % f = 10*Fs/Le:1*Fs/Le:NN*Fs/Le;

   % [ijk optimum] = min(abs(f-fr)); % Index gives the position of fr in the vector f
   % Optimummin=optimum-10;
   % Optimummax=optimum+10;
   % [ijk optimum] = max(S(Optimummin:Optimummax)); % Index gives the position of max spectrum
   % optimum=optimum+Optimummin-1; % Index gives the position of max spectrum
   % fr_newA=f(optimum);
   % fr=fr_new;
   % save filename S f fr_newA

    % plot(10*Fs/Le:1*Fs/Le:NN*Fs/Le,(FT(11:NN+1).^1),'k'); %,'LineWidth',lw
    % xlabel('Frequency (Hz)');%ylabel('Amplitude');%set(gca,'Fontsize',15);
    %set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman');
    % ylim([0 ddd]);box on

else
   % nsamples=floor(length(FT)/2);
   % S = FT(1:nsamples)./dmm;
   % S(1:10)=0;
   % f=(0:nsamples-1)/(nsamples-1)*Fs/(2^LM1)/2;
   % f = 10*Fs/length(FT):1*Fs/length(FT):floor(NN)*Fs/length(FT);
   % temporary=(10*Fs/length(FT):1*Fs/length(FT):floor(NN)*Fs/length(FT));
   fmax=(Fs/2)/(2^LM1); % Max frequency of the envelope LM1 is the level of decomposition
   NN=length(FT);
   freque=[0:1:NN-1]*Fs/NN; % Frequency axis
   [xyz index_p] = min(abs(freque-fmax)); % Index_p gives the position of fmax in the vector f (for plotting purposes only)
   S = FT(1:index_p)./dmm;
   f = freque(1:index_p);
   global fr

   [ijk optimum] = min(abs(f-fr)); % Optimum gives the position of fr in the vector f
   Optimummin=optimum-10;   
   Optimummax=optimum+10;  
   [ijk optimum] = max(S(Optimummin:Optimummax)); % Optimum gives the position of max spectrum
   optimum=optimum+Optimummin-1; % Optimum gives the position of max spectrum
   fr_newA=f(optimum);
   % fr=fr_new;
   save filename S f fr_newA

     plot(freque(1:index_p),FT(1:index_p)./dmm,'k') % plot the spectrum in the frequency band of interest
%    plot(10*Fs/length(FT):1*Fs/length(FT):floor(NN)*Fs/length(FT),(FT(11:floor(NN)+1).^1)./dmm,'k')
%    freq=10*Fs/length(FT):1*Fs/length(FT):Fs/2;
  
    xlabel('Frequency (Hz)'),%ylabel('Amplitude');%set(gca,'Fontsize',15);
    %set(gca,'FontWeight','Bold');set(gca,'Fontname','Times new roman');
    ylim([0 ddd]);box on;
    
end
end






